Attribute VB_Name = "saprfcvr1"
Rem --------------------------------------------------------------------------
Rem   SAP AG - R/3 Remote Function Call Interface Generation
Rem     RFC_MSVB_SR_EXP EN 46D 29.06.2003 15:28
Rem     Complete Vis.Basic server exa.
Rem     saprfcvr.bas
Rem --------------------------------------------------------------------------

Global gCommand$, gOutState%, gOutText$, gFileIn$, gFileOut$, gh%

Rem Rem ABAP/4 data types      ANSI C         Visual Basic    Comment
Rem Const gTYPC     = 0       'RFC_CHAR       STRING $        characters
Rem Const gTYPDATE  = 1       'RFC_DATE       STRING $        date (YYYYMMDD)
Rem Const gTYPP     = 2       'RFC_BCD        STRING $        packed numbers
Rem Const gTYPTIME  = 3       'RFC_TIME       STRING $        time (HHMMSS)
Rem Const gTYPX     = 4       'RFC_BYTE       STRING $        raw data
Rem Const gTYPTABH  = 5       'not used here
Rem Const gTYPNUM   = 6       'RFC_NUM        STRING $        digits
Rem Const gTYPFLOAT = 7       'RFC_FLOAT      FLOAT #         floating point
Rem Const gTYPINT   = 8       'RFC_INT        LONG &          4 byte integer
Rem Const gTYPINT2  = 9       'RFC_INT2       INTEGER %       2 byte integer
Rem Const gTYPINT1  = 10      'RFC_INT1       INTEGER %       1 byte integer
Rem Const gTYPB     = 11      'not used here
Rem Const gTYP1     = 12      'not used here
Rem Const gTYP2     = 13      'not used here

Rem RFC_MODE Rfc open modus
Rem Const RFC_MODE_R3ONLY = 0 'only for R/3 systems, any kind of user
Rem Const RFC_MODE_CPIC   = 1 'can be used for R/2, but CPIC-Users only

Rem RFC_RC Rfc return codes
Const RFC_OK = 0            'OK
Rem Const RFC_FAILURE       = 1 'error occured
Rem Const RFC_EXCEPTION     = 2 'exception raised
Rem Const RFC_SYS_EXCEPTION = 3 'system exception raised, connection closed
Rem Const RFC_CALL          = 4 'call received
Rem Const RFC_INTERNAL_COM  = 5 'internal communication, repeat
Rem Const RFC_CLOSED        = 6 'connection closed by the other side
Const RFC_RETRY = 7         'no data yet (RfcListen only)
Rem Const RFC_NO_TID        = 8 'no transaction ID available
Rem Const RFC_EXECUTED      = 9 'function already executed

Rem error info type definition
Type RFC_ERROR_INFO
  key     As String * 33
  status  As String * 128
  message As String * 256
  intstat As String * 128
End Type

Rem general RFC functions
Declare Function RfcOpenExt Lib "librfc32.dll" (ByVal destination$, ByVal mode%, ByVal hostname$, ByVal sysnr%, ByVal gwhost$, ByVal gwservice$, ByVal client$, ByVal user$, ByVal password$, ByVal language$, ByVal trace%) As Integer
Declare Sub RfcClose Lib "librfc32.dll" (ByVal hRfc As Long)
Declare Function RfcLastError Lib "librfc32.dll" (RfcErrorInfo As RFC_ERROR_INFO) As Integer

Rem RFC parameter type definition
Type RFC_PARAMETER
  name As String  'name of the field  (in the interface definition of the function)
  nlen As Integer 'length of the name (should be len(name))
  type As Integer 'datatype of the field
  leng As Integer 'length of the field in Bytes
  addr As Long    'address of the field to be exported or imported
End Type

Rem Extended RFC functions
Declare Function RfcAllocParamSpace Lib "librfc32.dll" (ByVal numexp%, ByVal numimp%, ByVal numtab%) As Long
Declare Function RfcFreeParamSpace Lib "librfc32.dll" (ByVal hSpace&) As Integer
Declare Function RfcAddExportParam Lib "librfc32.dll" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, par As Any) As Integer
Declare Function RfcAddExportString Lib "librfc32.dll" Alias "RfcAddExportParam" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, ByVal par As String) As Integer
Declare Function RfcAddImportParam Lib "librfc32.dll" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, par As Any) As Integer
Declare Function RfcAddImportString Lib "librfc32.dll" Alias "RfcAddImportParam" (ByVal hSpace&, ByVal parpos%, ByVal parname$, ByVal parnamelen%, ByVal partype%, ByVal parlen%, ByVal par As String) As Integer
Declare Function RfcAddTable Lib "librfc32.dll" (ByVal hSpace&, ByVal tabpos%, ByVal tabname$, ByVal tabnamelen%, ByVal tabtype%, ByVal tablen%, ByVal tabhandle As Long) As Integer
Declare Function RfcCallExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&, ByVal funcname$) As Integer
Declare Function RfcReceiveExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&, ByVal exception$) As Integer
Declare Function RfcCallReceiveExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&, ByVal funcname$, ByVal exception$) As Integer
Declare Function RfcAcceptExt Lib "librfc32.dll" (ByVal arguments As String) As Long

Declare Function RfcInstallFunction Lib "librfc32.dll" (ByVal funcname As String, ByVal funcpointer As Long, ByVal docu As String) As Long
Declare Function RfcInstallFunctionExt Lib "librfc32.dll" (ByVal hRfc As Long, ByVal funcname$, ByVal funcpointer&, ByVal docu$) As Long
Declare Function RfcWinInstallFunction Lib "librfc32.dll" (ByVal hRfc As Long, ByVal funcname$, ByVal funcpointer&, ByVal docu$) As Long
Declare Function RfcDispatch Lib "librfc32.dll" (ByVal hRfc As Long) As Long
Declare Function RfcListen Lib "librfc32.dll" (ByVal hRfc As Long) As Long

Declare Function RfcGetName Lib "librfc32.dll" (ByVal hRfc%, ByVal funcname$) As Integer
Declare Function RfcGetDataExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&) As Integer
Declare Function RfcGetTableHandle Lib "librfc32.dll" (ByVal hSpace&, ByVal tableno%) As Long
Declare Function RfcSendDataExt Lib "librfc32.dll" (ByVal hRfc%, ByVal hSpace&) As Integer
Declare Function RfcRaise Lib "librfc32.dll" (ByVal hRfc%, ByVal exception$) As Integer
Declare Function RfcAbort Lib "librfc32.dll" (ByVal hRfc%, ByVal text$)

Rem RFC_ITMODE RFC internal table mode
Rem Const RFC_ITMODE_BYREFERENCE = 0 'table is passed by reference
                                     '(ALLWAYS USE THIS)
Rem Const RFC_ITMODE_BYVALUE     = 1 'table is passed by value, changes are not transported back
                                     '(internal use only)
Rem Const RFC_ITMODE_KEEPALIVE   = 2 'table is passed by reference, but is kept alive after returning
                                     '(i.e. after RfcSendData, internal use only)

Rem RFC table type definition
Type RFC_TABLE
  name As String     'name of the table (in the interface definition of the function)
  nlen As Integer    'length of the name (should be len(name))
  type As Integer    'datatype of the lines of the table
  leng As Integer    'length of a row in bytes
  ithandle As Long   'table handle (type ITAB_H)
  itmode As Integer  'mode, how this table has to be received :  call by reference <-> call by value
  newitab As Integer 'table was created by RfcGetData
End Type

Rem general table functions
Declare Function ItCreate Lib "librfc32.dll" (ByVal ItName$, ByVal ItRecLen%, ByVal ItOccurs%, ByVal mem%) As Long
Declare Function ItDelete Lib "librfc32.dll" (ByVal hIt&) As Integer
Declare Function ItGetLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Long
Declare Function ItInsLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Long
Declare Function ItAppLine Lib "librfc32.dll" (ByVal hIt&) As Long
Declare Function ItDelLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Integer
Declare Function ItGupLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%) As Long
Declare Function ItCpyLine Lib "librfc32.dll" (ByVal hIt&, ByVal ItLine%, ByVal dest As Long) As Integer
Declare Function ItFree Lib "librfc32.dll" (ByVal hIt&) As Integer
Declare Function ItFill Lib "librfc32.dll" (ByVal hIt&) As Integer
Declare Function ItLeng Lib "librfc32.dll" (ByVal hIt&) As Integer

Rem kernel functions
Declare Function lockWindowUpdate Lib "user" (ByVal hWnd As Integer) As Integer
Declare Sub hmemcpy Lib "kernel" (hpvDest As Any, hpvSource As Any, cbCopy As Integer)
Declare Sub structToPointer Lib "kernel" Alias "hmemcpy" (ByVal hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Declare Sub pointerToStruct Lib "kernel" Alias "hmemcpy" (hpvDest As Any, ByVal hpvSource As Any, ByVal cbCopy As Long)

Rem --------------------------------------------------------------------------
Rem
Rem   Called function RFC_PING
Rem       exporting
Rem       importing
Rem       tables
Rem       exceptions
Rem
Rem --------------------------------------------------------------------------

Rem server stub see function srv_rfc_ping()
Rem server function see function rfc_ping()

Sub printo(text$, pos%)
  If Len(foOut.tbOut.text) > 4192 Then
    foOut.tbOut.text = Mid$(foOut.tbOut.text, 2048, Len(foOut.tbOut.text))
    foOut.tbOut.SelStart = Len(foOut.tbOut.text)
  End If
  foOut.tbOut.SelText = Space$(pos) & text: gOutText = foOut.tbOut.text
End Sub

Sub OUT(text$, pos%)
  printo text & Chr(13) & Chr(10), pos
  If gFileOut <> "" Then Print #1, "=" & text$
End Sub

Sub NL()
  printo Chr(13) & Chr(10), 0
End Sub

Sub Help(topic$, subtopic$, text$)

  Rem general help
  If topic = "h" Then
    OUT "This is a server example programm for SAP Remote Function Call.", 6
    OUT "The program was generated by the R/3 RFC Interface Generator.", 6
    OUT "For further information about the example see saprfcvr.txt.", 6
    OUT "To get help using the example, answer '?' on any item.", 6
    OUT "The example has been generated for function module:", 6: NL
    OUT "- RFC_PING", 8
    OUT "  RFC-Ping.", 8: NL
  End If

  Rem program arguments help
  If topic = "s" Then
    OUT "Starting the generated external server you can use the following", 6
    OUT "additional program arguments:", 6: NL
    OUT "-i <filename>               input from file", 8
    OUT "-o <filename>               output to file", 8
    OUT "-?                          this text", 8: NL
  End If

  If topic = "end" Then
    OUT "Thank you for using the SAP Business Application Programming Interface", 2
    OUT "and SAP Remote Function Call. For further information please call us at:", 2
    OUT "SAP America Inc. Western Reginal Office 950 Towerlane Foster City", 2
    OUT "CA 94404-2127, Phone (+1) 415 637 1655 FAX (+1) 415 637 9592 or", 2
    OUT "SAP AG Basisvertrieb Postbox 1461 D-69185 Walldorf Germany,", 2
    OUT "Phone (+49) 6227 34 1763 FAX (+49) 6227 34 1880.", 2: NL
  End If
  If topic = "i" Then
    OUT "To input function module parameters, answer 'y' and type in", 6
    OUT "parameter values and append table rows if necessary.", 6: NL
  End If
  If topic = "isi" Or topic = "esi" Then
    OUT "To fill in the structure, answer 'y' and type in structure fields.", 10: NL
  End If
  If topic = "iso" Or topic = "eso" Then
    OUT "To display the structure fields, answer 'y'.", 10: NL
  End If
  If topic = "ti" Then
    OUT "To append a table row, answer 'y' and type in table row fields.", 10: NL
  End If
  If topic = "to" Then
    OUT "To get the table row and display the row fields, answer 'y' or '*' for all rows.", 10: NL
  End If
  If topic = "xi" Then
    OUT "Terminates the function. To raise the exception, answer 'y'.", 10: NL
  End If
  If topic = "xo" Then
    OUT "Terminated the called function.", 10: NL
  End If
  If topic = "c" Then
    OUT "To call the function module, answer 'y'.", 6: NL
  End If
  If topic = "a" Then
    OUT "To call the function module again, answer 'y'.", 6: NL
  End If

  If topic = "f" Then
    OUT "Called function RFC_PING", 2: NL
  End If

End Sub

Sub INS(topic$, subtopic$, text$, pos%, leng%, s$)
  Do: printo text & Space$(leng - Len(text$)) & " : ", pos
    If gFileIn <> "" Then 'read from input file comparing input event (text)
      Do While (s <> "=" & text): Input #2, s: Loop: Input #2, s: s = Mid$(s, 2, Len(s) - 1)
      printo s & Chr(13) & Chr(10), 0
    Else 'read from input form (modal)
      gOutState = True: foOut.Hide: foOut.Show 1: foOut.Show
      s = Mid$(foOut.tbOut.text, Len(gOutText) + 1, Len(foOut.tbOut.text) - Len(gOutText))
      s = Mid$(s, 1, InStr(s, Chr(13) & Chr(10)) - 1): foOut.tbOut.text = gOutText & s & Chr(13) & Chr(10)
      rc% = lockWindowUpdate(0): DoEvents: gOutText = foOut.tbOut.text: gOutState = False
    End If
    If gFileOut <> "" Then
      Print #1, "=" & text: Print #1, "<" & s 'write output file
    End If
    If s = "?" Then Help topic, subtopic, text
  Loop While (s = "?")
End Sub

Sub OUTS(text$, pos%, leng%, s$)
  printo text & Space$(leng - Len(text)) & " : " & s & Chr(13) & Chr(10), pos
  If gFileOut <> "" Then Print #1, "=" & text: Print #1, ">" & s
End Sub

Sub SETCHAR(var$, s$, leng%)
  If Len(s) >= leng Then var = Mid$(s, 1, leng%) Else var = s & Space$(leng% - Len(s))
End Sub

Sub GETCHAR(var$, s$)
  s = var
End Sub

Sub SETDATE(var$, s$)
  If Len(s) >= 8 Then var = Mid$(s, 1, 8) Else var = s & String$(8 - Len(s), "0")
End Sub

Sub GETDATE(var$, s$)
  s = var
End Sub

Sub SETFLOAT(var#, s$)
  If s = "" Then var = 0 Else var = CDbl(s)
End Sub

Sub GETFLOAT(var#, s$)
  s = Format$(var)
End Sub

Sub SETINT(var&, s$)
  If s = "" Then var = 0 Else var = CLng(s)
End Sub

Sub GETINT(var&, s$)
  s = Format$(var)
End Sub

Sub SETNUM(var$, s$, leng%)
  If Len(s) >= leng Then var = Mid$(s, 1, leng%) Else var = String$(leng% - Len(s), "0") & s
End Sub

Sub GETNUM(var$, s$)
  s = var
End Sub

Sub SETTIME(var$, s$)
  If Len(s) >= 6 Then var = Mid$(s, 1, 6) Else var = s & String$(6 - Len(s), "0")
End Sub

Sub GETTIME(var$, s$)
  s = var
End Sub

Sub SETINT1(var%, s$)
  If s = "" Then var = 0 Else var = CInt(s)
End Sub

Sub GETINT1(var%, s$)
  s = Format$(var)
End Sub

Sub SETINT2(var%, s$)
  If s = "" Then var = 0 Else var = CInt(s)
End Sub

Sub GETINT2(var%, s$)
  s = Format$(var)
End Sub

Function CheckArg(arg$, value$) As Integer
  Rem check given program argument and return value
  If arg$ = "" Then CheckArg = False: Exit Function
  If arg$ = gCommand$ Then CheckArg = True: Exit Function
  k% = InStr(gCommand$, arg$ & " ")
  If k% <> 0 Then
    s$ = Mid$(gCommand$, k% + Len(arg$) + 1, Len(gCommand$) - k% - Len(arg$))
    k% = InStr(s$, " "): If k% <> 0 Then s$ = Mid$(s$, 1, k% - 1)
    If Mid$(s$, 1, 1) = "-" Then value = "" Else value = s$
    CheckArg = True: Exit Function
  End If
  k% = InStr(gCommand$, arg$)
  If k% = (Len(gCommand$) - Len(arg$) + 1) Then CheckArg = True: Exit Function
  CheckArg = False
End Function

Sub rfc_error(operation$)
  Dim RfcErrorInfo As RFC_ERROR_INFO
  RfcErrorInfo.key = String$(33, 0): RfcErrorInfo.status = String$(128, 0)
  RfcErrorInfo.message = String$(256, 0): RfcErrorInfo.intstat = String$(128, 0)
  OUT "RFC error", 0
  OUTS "operation/code", 0, 15, operation
  rc% = RfcLastError(RfcErrorInfo)
  OUTS "key", 0, 15, RTrim0(RfcErrorInfo.key)
  OUTS "status", 0, 15, RTrim0(RfcErrorInfo.status)
  OUTS "message", 0, 15, RTrim0(RfcErrorInfo.message)
  OUTS "internal status", 0, 15, RTrim0(RfcErrorInfo.intstat): NL
  RfcClose (0) 'RFC_HANDLE_NULL
End Sub

Function RTrim0(text$) As String
  s$ = text: If InStr(s$, Chr$(0)) <> 0 Then s$ = Mid$(text, 1, InStr(s$, Chr$(0)) - 1)
  RTrim0 = s$
End Function

Function rfc_ping(ByVal hRfc%, xException$) As Long


OUT "Jetzt Ping", 1

rfc_ping = 0 'RFC_OK

End Function

Function srv_rfc_ping(hRfc%) As Integer

  Rem ABAP/4 data types      ANSI C         Visual Basic    Comment
  Const vTYPC = 0           'RFC_CHAR       STRING $        characters
  Const vTYPDATE = 1        'RFC_DATE       STRING $        date (YYYYMMDD)
  Const vTYPP = 2           'RFC_BCD        STRING $        packed numbers
  Const vTYPTIME = 3        'RFC_TIME       STRING $        time (HHMMSS)
  Const vTYPX = 4           'RFC_BYTE       STRING $        raw data
  Const vTYPTABH = 5        'not used here
  Const vTYPNUM = 6         'RFC_NUM        STRING $        digits
  Const vTYPFLOAT = 7       'RFC_FLOAT      FLOAT #         floating point
  Const vTYPINT = 8         'RFC_INT        LONG &          4 byte integer
  Const vTYPINT2 = 9        'RFC_INT2       INTEGER %       2 byte integer
  Const vTYPINT1 = 10       'RFC_INT1       INTEGER %       1 byte integer
  Const vTYPB = 11          'not used here
  Const vTYP1 = 12          'not used here
  Const vTYP2 = 13          'not used here

  Rem RFC variables
  ReDim Importing(0 To 0) As RFC_PARAMETER
  ReDim Exporting(0 To 0) As RFC_PARAMETER
  ReDim Tables(0 To 0) As RFC_TABLE
  Dim RfcRc As Integer
  Dim hSpace As Long

  Rem param variables
  Dim xException As String

  Rem allocate param space
  hSpace = RfcAllocParamSpace(0, 0, 0)
  If hSpace = 0 Then srv_rfc_ping = 1: Exit Function 'RFC_FAILURE

  Importing(0).name = ""

  Tables(0).name = ""

  RfcRc = RfcGetDataExt(hRfc, hSpace)
  If RfcRc <> 0 Then rc% = RfcFreeParamSpace(hSpace): srv_rfc_ping = 1: Exit Function 'RFC_FAILURE

  Rem call RFC function
RfcRc = rfc_ping(hRfc, xException)

  If RfcRc = 2 Then rc% = RfcRaise(hRfc, xException): rc% = RfcListen(hRfc) 'RFC_EXCEPTION

  Exporting(0).name = ""

  If RfcRc = 0 Then RfcRc = RfcSendDataExt(hRfc, hSpace) 'RFC_OK

  Rem free param space
  rc% = RfcFreeParamSpace(hSpace)

  srv_rfc_ping = RfcRc

End Function

Sub Main()
  gCommand$ = Command$

  Rem RFC variables
  Dim vHelp%, s$
  Dim hRfc%, RfcRc%, RfcFuncName$

  Rem open files
  gFileOut = "": gFileIn = ""
  If gCommand$ <> "" Then
    rc% = CheckArg("-o", gFileOut): If gFileOut <> "" Then Open gFileOut For Output As #1
    rc% = CheckArg("-i", gFileIn): If gFileIn <> "" Then Open gFileIn For Input As #2
  End If

  gOutText = "": gOutState = False: foOut.Show
  OUT "SAP AG, Walldorf - Business Application Programming Interface", 0: NL

  Rem program arguments
  If gCommand$ <> "" Then
    If CheckArg("-?", s) = True Then vHelp = True
    If CheckArg("?", s) = True Then vHelp = True
    If vHelp = True Then Help "h", "", "": Help "s", "", "": Help "end", "", "": Exit Sub
  End If

  Rem accept connection
  'hRfc = RfcAcceptExt(gCommand$)
  
  hRfc = RfcAcceptExt("-aSCHNITTE.RFCTEST -gschnitte -xSAPGW00")
  If hRfc = 0 Then rfc_error "RfcAcceptExt": Exit Sub


RfcRc = RfcInstallFunctionExt(hRfc, "RFC_PING2", AddressOf rfc_ping, "test")

If RfcRc <> 0 Then
    MsgBox "rfcrc = " & CStr(rffcrc)
End If



  Rem wait for calls using RfcGetName. RFC_PING not supported!
'  Do While RfcRc = 0 Or RfcRc = 2 'RFC_OK or RFC_EXCEPTION
'    RfcFuncName = String$(256, 0)
'    RfcRc = RfcGetName(hRfc, RfcFuncName)
'    If RfcRc <> 0 Then Exit Do
'    RfcFuncName = RTrim0(RfcFuncName)
'    If RfcFuncName = "RFC_PING" Then RfcRc = srv_rfc_ping(hRfc)
'  Loop

    

Do While RfcRc = RFC_OK
    RfcRc = RFC_RETRY
    Do While RfcRc = RFC_RETRY
        RfcRc = RfcListen(hRfc)
        DoEvents
    Loop
    
    
    
    RfcRc = RfcDispatch(hRfc)
    
    DoEvents
Loop

    
  RfcClose (hRfc)

  Help "end", "", ""

  Rem close files
  If gFileOut <> "" Then Close #1: If gFileIn <> "" Then Close #2

End Sub

